require( "HiddenObject/Script/style.lua" );

kButtonSpacing = 60;
kButtonY = 110;
kButtonX = 120;


HeaderFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  36,
  Color(131, 167, 184, 255),
};


HelpMenuButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  24,
  Color(131, 167, 184, 255),
};


LongGraphics = {
	"HiddenObject/UI/HelpWindow/hiddenobjectnormal",
	"HiddenObject/UI/HelpWindow/hiddenobjectdown",
	"HiddenObject/UI/HelpWindow/hiddenobjectover"

};


LongStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = LongGraphics ,
	flags = kVAlignCenter + kHAlignCenter,
};


OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = HelpMenuButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};
Mastermind_HelpGraphics = {
	"HiddenObject/UI/HelpWindow/mastermindnormal",
	"HiddenObject/UI/HelpWindow/masterminddown",
	"HiddenObject/UI/HelpWindow/mastermindover"
};


Mastermind_HelpStyle = {
	parent = DefaultStyle,
	font = HelpMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = Mastermind_HelpGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


Simon_HelpGraphics = {
	"HiddenObject/UI/HelpWindow/simonnormal",
	"HiddenObject/UI/HelpWindow/simondown",
	"HiddenObject/UI/HelpWindow/simonover"
};


Simon_HelpStyle = {
	parent = DefaultStyle,
	font = HelpMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = Simon_HelpGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


Concentration_HelpGraphics = {
	"HiddenObject/UI/HelpWindow/concentrationnormal",
	"HiddenObject/UI/HelpWindow/concentrationdown",
	"HiddenObject/UI/HelpWindow/concentrationover"
};


Concentration_HelpStyle = {
	parent = DefaultStyle,
	font = HelpMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = Concentration_HelpGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};

FooterMenuButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  16,
  WhiteColor
};


FooterMenuGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover"
};


FooterMenuStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};


function HelpButtonLabel( label )

	color = Color(131, 167, 184, 255);	-- the default colors
	colorHighlight=Color(124,123,98,255)
	
	return Group{
		
		SelectLayer(0),
		ColorShadowText(5,8,kMenuButtonFontSize, label, color ),
		SelectLayer(1),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight ),
		SelectLayer(2),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight )
	}

end

function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 310; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 115; end
	return y;
end

MakeDialog
{
	name="help",
	fit=true;
	Bitmap
	{
		image="HiddenObject/UI/HelpWindow/background",
		x = GetWindowX(),
		y = GetWindowY(),
		
		Text
		{
			font = HeaderFont,
			name = "help",
			x=185, y=10,
			w=kMax,h=40,
			flags = kVAlignCenter + kHAlignLeft,
			label= "help",
		};
		
		SetStyle( LongStyle  ),		
		--SetStyle(CommonStyle),
				
		Button
		{
			name="hiddenobjectgame_help",
			HelpButtonLabel("hiddenobjectgame"),
			align=kHAlignCenter+kVAlignCenter,
			x=kCenter,y=kButtonY,
			command=
				function()
					DoModal("HiddenObject/Script/hiddenobjectgamehelp.lua");
				end
		},


		--SetStyle( Mastermind_HelpStyle ),	

		Button
		{
			name="mastermind_help",
			HelpButtonLabel("mastermind"),
			align=kHAlignCenter+kVAlignCenter,
			x=kCenter,y=kButtonY + 3*kButtonSpacing,
			command=
				function()
					DoModal("HiddenObject/Script/mastermindhelp.lua");
				end
		},
		
		--SetStyle( Simon_HelpStyle ),	
		Button
		{
			name="simon_help",
			HelpButtonLabel("simon"),
			align=kHAlignCenter+kVAlignCenter,
			x=kCenter,y=kButtonY + kButtonSpacing,
			command=
				function()
					DoModal("HiddenObject/Script/simonhelp.lua");
				end
		},


		--SetStyle( Concentration_HelpStyle ),
		Button
		{
			name="concentration_help",
			HelpButtonLabel("concentration"),
			align=kHAlignCenter+kVAlignCenter,
			x=kCenter,y=kButtonY + 2*kButtonSpacing,
			command=
				function()
					DoModal("HiddenObject/Script/concentrationhelp.lua");
				end
		},
		
		SetStyle( OkStyle ),
		Button
		{
			name="back",
			label = "back",
			align=kHAlignCenter+kVAlignCenter,
			x=kCenter,y=350,
			close = true,
		},
	},
}